package app

import (
	"errors"
	"fmt"
	"os"
	"time"

	"code.justin.tv/content/evo/model"
	log "github.com/sirupsen/logrus"
)

func InitTextLog() {
	log.SetFormatter(&log.TextFormatter{
		FullTimestamp:    true,
		DisableTimestamp: false,
		TimestampFormat:  "15:04:05.999",
		DisableSorting:   true,
		QuoteEmptyFields: true,
	})
}

func InitJSONLog() {
	log.SetFormatter(&log.JSONFormatter{
		TimestampFormat:  time.RFC3339,
		DisableTimestamp: false,
	})
}

func InitDB() (*model.EvoDB, error) {
	if dbURL, found := os.LookupEnv("DATABASE_URL"); !found {
		return nil, errors.New("$DATABASE_URL not set")
	} else if db, err := model.InitDB(dbURL); err != nil {
		return nil, fmt.Errorf("failed to connect to db at %q: %s", dbURL, err)
	} else {
		return db, nil
	}
}
