package events

import (
	"encoding/json"
	"testing"
	"time"

	"code.justin.tv/content/evo/util"
)

func TestMinuteWatchedJSON(t *testing.T) {
	data := []byte(`{
      "Name": "minute-watched",
      "Fields": {
        "channel": "twitchpresents",
        "channel_id": "149747285",
        "live": "true",
        "minutes_logged": "23",
        "subscriber_web": "false",
        "time": "2017-11-03 16:31:02",
        "user_id": "12345"
      }
    }`)

	var event MinuteWatchedEvent
	if err := json.Unmarshal(data, &event); err != nil {
		t.Fatalf("unexpected error unmarshaling from JSON: %s", err)
	}

	expected := MinuteWatchedEvent{
		Channel:       "twitchpresents",
		ChannelID:     149747285,
		Live:          true,
		MinutesLogged: 23,
		UserID:        "12345",
		Subscriber:    false,
		Time:          time.Date(2017, 11, 3, 16, 31, 2, 0, pdt).UTC(),
	}

	if diffs := util.StructDiff(event, expected); len(diffs) > 0 {
		t.Fatal(util.DiffErrorMessage(diffs))
	}
}
