package main

import (
	"time"

	"code.justin.tv/content/evo/events"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	log "github.com/sirupsen/logrus"
)

func init() {
	log.SetFormatter(&log.JSONFormatter{
		TimestampFormat:  time.RFC3339,
		DisableTimestamp: false,
	})
}

func main() {
	awsCreds := credentials.NewSharedCredentials("/home/cvp/.aws/credentials", "twitch-esports-aws")
	awsConfig := aws.NewConfig().WithRegion("us-west-2").WithCredentials(awsCreds)
	awsSession, err := session.NewSession(awsConfig)
	log.Info("initialized AWS session")
	if err != nil {
		log.Fatalf("error initializing AWS session: %s", err)
	}

	recvEvent := make(chan struct{}, 10)
	stop := make(chan struct{}, 1)
	go func() {
		for i := 0; i < 10; i++ {
			<-recvEvent
		}
		stop <- struct{}{}
	}()
	stream, err := events.InitKinesis(awsSession, func(event events.MinuteWatchedEvent) error {
		recvEvent <- struct{}{}
		log.WithFields(log.Fields{
			"user_id": event.UserID,
			"channel": event.Channel,
			"live":    event.Live,
			"total":   event.MinutesLogged,
		}).Info("minute watched")
		return nil
	})
	if err != nil {
		log.Fatalf("error initializing stream: %s", err)
	}
	log.Info("initialized Kinesis stream")

	select {
	case err := <-stream.Run():
		log.Fatalf("stream error: %s", err)
	case <-stop:
		log.Info("stopping stream")
		stream.Stop()
		log.Info("waiting 3 seconds...")
		time.Sleep(3 * time.Second)
	}

	log.Infof("stopped")
}
