package model

import (
	"fmt"

	"github.com/jmoiron/sqlx"
	_ "github.com/lib/pq"
	log "github.com/sirupsen/logrus"
)

const (
	SCHEMA_FILE = "schema.sql"
)

type EvoDB struct {
	logger *log.Entry
	conn   *sqlx.DB

	// Pre-cached badge/evolution metadata.
	evoMap  map[int]*Evolution
	evoSets map[int]*EvolutionSet
}

func InitDB(url string) (*EvoDB, error) {
	logger := log.WithFields(log.Fields{
		"context":      "model/postgres",
		"postgres_url": url,
	})

	logger.Infof("establishing connection", url)
	conn, err := sqlx.Connect("postgres", url)
	if err != nil {
		return nil, err
	}

	// TODO: move db init and seeding to separate component
	logger.Infof("applying schema")
	if _, err := sqlx.LoadFile(conn, SCHEMA_FILE); err != nil {
		conn.Close()
		return nil, fmt.Errorf("error applying schema: %s", err)
	}

	db := &EvoDB{
		logger:  logger,
		conn:    conn,
		evoSets: nil,
	}

	if err = db.SyncEvoCache(); err != nil {
		conn.Close()
		log.Errorf("error caching evolution set metadata: %s", err)
		return nil, err
	}

	return db, nil
}
