package util

import "strconv"

// As `strconv.Atoi()`, except that the empty string evaluates to a default value.
func Atoi(s string, d int) (int, error) {
	if s == "" {
		return d, nil
	}
	return strconv.Atoi(s)
}

// As `strconv.ParseBool()`, except that the empty string evaluates to false.
func Atob(s string, d bool) (bool, error) {
	if s == "" {
		return d, nil
	}
	return strconv.ParseBool(s)
}
