// Load application styles
require('styles/index.scss');

var store = window.localStorage;

function initToast() {
  var input = document.querySelector('.input__input');
  var button = document.querySelector('button');
  var toast = document.querySelector('.toast');
  var dismiss = document.querySelector('.toast__dismiss');

  function selectLink(e) {
    e.preventDefault();
    input.select();
  }

  function copyLink(e) {
    e.preventDefault();
    input.select();
    try {
      if (document.execCommand('copy')) {
        toast.className += ' toast--success';
        setTimeout(function() { toast.className = toast.className.replace('toast--success', '') }, 1000);
      }
    } catch (err) {}
  }

  function dismissToast(e) {
    e.preventDefault()
    store.setItem('hide-toast', true);
    toast.className = toast.className.replace('toast--show', '');
  }

  dismiss.addEventListener('click', dismissToast);
  button.addEventListener('click', copyLink);
  input.addEventListener('click', selectLink);
}

document.addEventListener('DOMContentLoaded', function(e) {
  var toast = document.querySelector('.toast');
  var hideToast = store.getItem('hide-toast') || false;

  if (!hideToast) {
    toast.className += ' toast--show';
    initToast();
  }
});

