#!/bin/bash
#
# Creates dynamic configs for bird before the service starts.
#
# /etc/bird/bird_base.conf + /etc/bird/conf.d/*.conf -> /etc/bird/conf.d/bird_dynamic.conf

DATA=$(ip -o route get 192.16.0.1)
ADDR=$(echo "$DATA" | grep -o "src [0-9]*\.[0-9]*\.[0-9]*\.[0-9]*" | cut -d ' ' -f 2)
SUBN=$(echo "$DATA" | grep -o "via [0-9]*\.[0-9]*\.[0-9]*" | cut -d ' ' -f 2)
DA01="${SUBN}.1"
DA02="${SUBN}.2"
ASN="64512" # twitch internal bgp asn.

# Build config.
echo "router id ${ADDR};" > /etc/bird/conf.d/bird_dynamic.conf
cat /etc/bird/bird.conf >> /etc/bird/conf.d/bird_dynamic.conf
cat /etc/bird/conf.d/*.conf >> /etc/bird/conf.d/bird_dynamic.conf
cat >> /etc/bird/conf.d/bird_dynamic.conf <<EOF
template bgp upstream_switches {
  local as ${ASN};
  hold time 180;
  source address ${ADDR};
  import none;
  export filter announce_out;
}

protocol bgp 'da01' from upstream_switches {
	neighbor ${DA01} as ${ASN};
}

protocol bgp 'da02' from upstream_switches {
	neighbor ${DA02} as ${ASN};
}
EOF
