#!/bin/bash
#
# This prestart script sets up the dynamic bits for consul.
# Building this configuration at run time allows consul to be
# installed in a base AMI and become immediately available on boot.
#
# Usage (as root): /bin/bash /var/lib/consul/prestart.sh
#

PATH=/bin:/usr/bin:/sbin
POP=$(facter pop)
TEAM=$(facter twitch_team)
DIST=$(facter lsbdistcodename)
FQDN=$(hostname -f)
ADDR=$(ip -o route get 192.16.0.1 | grep -o "src .*" | cut -d ' ' -f 2)

# statsd is currently disabled.
#TELEMETRY="{\"telemetry\":{\"statsd_address\": \"statsd.internal.justin.tv:8125\", \"metrics_prefix\": \"consul.${POP}\"}}"
#echo "$TELEMETRY" | jq . > /etc/consul/01_dynamic_telemetry.json

DYNAMIC="{\"datacenter\": \"${POP}\", \"retry_join\": [\"consul-servers.${POP}.justin.tv\"], \"node_name\": \"${FQDN}\", \"advertise_addr\": \"${ADDR}\"}"
echo "$DYNAMIC" | jq . > /etc/consul/02_dynamic_data.json

# Legacy nodeinfo (to make sure lsconsul works..)
NODEINFO="{\"service\": {\"id\": \"nodeinfo\",\"name\": \"nodeinfo\",\"tags\": [\"fqdn=${FQDN}\",\"lsbdistcodename=${DIST}\",\"twitch_team=${TEAM}\"]}}"
echo "$NODEINFO" | jq . > /etc/consul/03_dynamic_service_nodeinfo.json
