job {
    name "systems-twitch-consul-template-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/consul-template-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Packages **/

        // Twitch Consul Client
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-consul-template-config*.deb twitch-consul-template-config.deb'
        fpmPackageFromDir 'rpm', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-consul-template-config*.rpm twitch-consul-template-config.rpm'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb *.rpm packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/consul-template-config', 'packages/'
    }
}

job {
    name 'systems-twitch-consul-template-deploy'
    using 'TEMPLATE-autobuild'
    parameters {
        stringParam 'GIT_COMMIT'
        stringParam 'RELEASE_VERSION'
    }
    scm {
        git {
            remote {
                github 'core-config-packages/consul-template-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            branches 'origin/master'
            clean true
        }
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            string('dta_tools_deploy', 'dtatoolsdeploy')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }
    steps {
        /** Upload Packages to Artifactory **/
        downloadDeployArtifact 'core-config-packages/consul-template-config'
        uploadDeb 'twitch-consul-template-config.deb'
        uploadRPM 'twitch-consul-template-config.rpm'
    }
}
