#!/usr/bin/env ruby

# Copied from
# https://git-aws.internal.justin.tv/systems/puppet/blob/59b62abd0e54ae889ce5216ef2fb1913ca137a27/modules/facts/lib/facter/hostname.rb
# with modifications to make it work standalone and produce only the pop fact.

# This is Twitch business logic.

# pop.rb
# checks to see if legacy hostname 'standard'
# sets facts:
#   pop

fqdn = `hostname -f`
ec2_placement_availability_zone = `/usr/bin/ec2metadata --availability-zone 2>/dev/null`.chomp
pop = "internal"

## for ec2 instances, set the pop automatically instead of parsing the hostname
if ec2_placement_availability_zone != ""
  # trim the availability zone letter to yield the region name
  pop = ec2_placement_availability_zone.slice(0..-2)
  # us-west-2 was incorrectly named us-west2 when it was created, so we need to
  # do some evil here...
  if pop == "us-west-2"
    pop = "us-west2"
  end

# if we have fqdn fact
elsif fqdn != ""
  sfqdn = fqdn.split('.')
  has_pop = sfqdn.length >= 4 ? true : false
  # Lookup from the end of the array to allow arbitrarily long hostnames:
  pop = has_pop ? sfqdn[-3] : 'internal'
end

puts 'pop='+pop
