job {
    name "systems-twitch-filebeat-config-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/filebeat-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Packages **/
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-filebeat-config*.deb twitch-filebeat-config.deb'
        fpmPackageFromDir 'rpm', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-filebeat-config*.rpm twitch-filebeat-config.rpm'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb *.rpm packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/filebeat-config', 'packages/'
    }
}

job {
    name 'systems-twitch-filebeat-config-deploy'
    using 'TEMPLATE-autobuild'
    parameters {
        stringParam 'GIT_COMMIT'
        stringParam 'RELEASE_VERSION'
    }
    scm {
        git {
            remote {
                github 'core-config-packages/filebeat-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            branches 'origin/master'
            clean true
        }
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            string('dta_tools_deploy', 'dtatoolsdeploy')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }
    steps {
        /** Upload Packages to Artifactory **/
        downloadDeployArtifact 'core-config-packages/filebeat-config'
        uploadDeb 'twitch-filebeat-config.deb'
        uploadRPM 'twitch-filebeat-config.rpm'
    }
}
