job {
    name "systems-twitch-ldap-client-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/ldap-client', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Package(s) **/
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-ldap-client*.deb twitch-ldap-client.deb'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/ldap-client', 'packages/'
    }
}

job {
    name 'systems-twitch-ldap-client-deploy'
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
        }
    }
    parameters {
       stringParam 'GIT_COMMIT'
    }
    steps {
        /** Upload Packages to Artifactory **/
        downloadDeployArtifact 'core-config-packages/ldap-client'
        uploadDeb 'twitch-ldap-client.deb', ['bionic']
    }
}
