job {
    name "systems-twitch-ldap-master-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/ldap-master', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Package(s) **/
        // Twitch Core Facts
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-ldap-master*.deb twitch-ldap-master.deb'
        fpmPackageFromDir 'rpm', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-ldap-master*.rpm twitch-ldap-master.rpm'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb *.rpm packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/ldap-master', 'packages/'
    }
}

job {
    name 'systems-twitch-ldap-master-deploy'
    using 'TEMPLATE-autobuild'
    parameters {
        stringParam 'GIT_COMMIT'
        stringParam 'RELEASE_VERSION'
    }
    scm {
        git {
            remote {
                github 'core-config-packages/ldap-master', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            branches 'origin/master'
            clean true
        }
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            string('dta_tools_deploy', 'dtatoolsdeploy')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }
    steps {
        /** Upload Packages to Artifactory **/
        downloadDeployArtifact 'core-config-packages/ldap-master'
        uploadDeb 'twitch-ldap-master.deb'
        uploadRPM 'twitch-ldap-master.rpm'
    }
}
