job {
    name "systems-twitch-packetbeat-config-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/packetbeat-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Packages **/

        // Twitch Packetbeat Config
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-packetbeat-config*.deb twitch-packetbeat-config.deb'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/packetbeat-config', 'packages/'
    }
}

job {
    name 'systems-twitch-packetbeat-config-deploy'
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
        }
    }
    parameters {
       stringParam 'GIT_COMMIT'
    }
    steps {
        downloadDeployArtifact 'core-config-packages/packetbeat-config'
        uploadDeb 'twitch-packetbeat-config.deb'

    }
}
