# Twitch Sandstorm Config

**This package is actively used in production tiny bubble accounts.**

## deb: `twitch-sandstorm-config`

This repo creates a package that provides a base configuration for sandstorm.
The configuration has the assumption that your instances' (hosts') role names
in sandstorm match this pattern: `twitch_team`-`twitch_role`-`twitch_environment` (`team-role-env`)
You can see where this is used in the [prestart script](fpm_source/var/lib/sandstorm-agent/prestart.sh).

Using this package requires the following:
-   Facter facts created by the provisioning system:
    -   `pop` (ex: `cmh01`, `us-west-2`)
    -   `twitch_team` (ex: `systems`, `video`, `chat`, should match a sandstorm team from ldap)
    -   `twitch_role` (ex: `grafana`, `squid-proxy`, `dns-auth`)
    -   `twitch_environment` (ex: `production`, `development`)
-   A sandstorm role created with the name: `twitch_team-twitch_role-twitch_environment`
-   The system you install this on must be able to assume the sandstorm role you create.

If your package requires secrets from sandstorm, depend on this package then
place configs and templates in `/etc/sandstorm-agent/conf.d` and `/etc/sandstorm-agent/templates.d`.
