#!/bin/bash

# This script automatically populate the roleArn and Pop values in the base
# sandstorm configuration. Sandstorm role names must match the pattern used.

# Placing this configuration building in a prestart script allows this package
# to be installed in an AMI. The sandstorm config will auto-update before starting.

PATH=/bin:/usr/bin
POP=$(facter pop 2>/dev/null)
TEAM=$(facter twitch_team 2>/dev/null)
ROLE=$(facter twitch_role 2>/dev/null)
[ -z "$ROLE" ] && ROLE=$(facter cluster 2>/dev/null)
ENV=$(facter twitch_environment 2>/dev/null)
ARN="arn:aws:iam::734326455073:role/sandstorm/production/templated/role/${TEAM}-${ROLE}-${ENV}"

sed -i -e "s#roleArn = .*#roleArn = \"${ARN}\"#g" \
  -e "s#Pop = .*#Pop = \"${POP}\"#g" \
  /etc/sandstorm-agent/conf.d/01-config.conf

[ -d /etc/sandstorm-agent/unrendered.d ] || exit 0

for i in /etc/sandstorm-agent/unrendered.d/*; do
  [ "$i" != "/etc/sandstorm-agent/unrendered.d/unrendered.d_readme.txt" ] || continue
  sed -e "s/TEAM_PLACEHOLDER/${TEAM}/g" \
    -e "s/CLUSTER_PLACEHOLDER/${ROLE}/g" \
    -e "s/ENVIRONMENT_PLACEHOLDER/${ENV}/g" \
    -e "s/POP_PLACEHOLDER/${POP}/g" \
    $i > "/etc/sandstorm-agent/templates.d/$(basename ${i})"
done
