job {
    name "systems-twitch-sandstorm-config-build"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'core-config-packages/sandstorm-config', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        /** Build Package(s) **/
        // Twitch Core Facts
        fpmPackageFromDir 'deb', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-sandstorm-config*.deb twitch-sandstorm-config.deb'
        fpmPackageFromDir 'rpm', 'fpm_source', 'fpm_scripts'
        shell 'mv twitch-sandstorm-config*.rpm twitch-sandstorm-config.rpm'

        // Move packages to a subfolder. for extract
        shell 'mkdir -p packages && mv -v *.deb *.rpm packages'

        // Upload packages to S3.
        saveDeployArtifact 'core-config-packages/sandstorm-config', 'packages/'
    }
}

job {
    name 'systems-twitch-sandstorm-config-deploy'
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
        }
    }
    parameters {
       stringParam 'GIT_COMMIT'
    }
    steps {
        /** Upload Packages to Artifactory **/
        downloadDeployArtifact 'core-config-packages/sandstorm-config'
        uploadDeb 'twitch-sandstorm-config.deb'
        uploadRPM 'twitch-sandstorm-config.rpm'
    }
}
