---
title: PubSub Topics and Schema
weight: 3
---

Sauron publishes live events so that clients can keep the Activity Feed in an up to date state. 

These events include all needed localizations and it is up to the client to select the appropriate language for the
user. The reason for this is that PubSub does not provide enough details on users to know their language preference
when publishing and does not provide any information on which users are connected to a given topic. This means that
Sauron must provide all translations for an event as a part of PubSub.

## Topics
Sauron publishes to two PubSub topics:
* `activity-feed-broadcaster-v2.<user_id>.<channel_id>`
    * Used by the broadcaster to receive events
    * Requires authentication
    * May also be used by editors to receive privileged events in the future
* `activity-feed-moderator-v2.<channel_id>`
    * Used by moderators and editors to receive events

## Schema
Sauron currently passes events represented by the following TypeScript definition.

```ts
interface Message {
    type: "activity_feed_event_create"
    data: ActivityEvent
}

interface ActivityEvent {
    id: string
    timestamp: string
    cursor: string
    channel_id: string
    source_user_id: string
    tyoe: string
    title: ActivityTextMap | undefined
    content: ActivityTextMap | undefined
    content_body: ActivityTextMap | undefined
    user_content: ActivityText | undefined
    category_id: string
}

interface ActivityTextMap {
    [language: string]: ActivityText
}

type ActivityText = ActivityTextFragment[];

interface ActivityTextFragment {
    type: TokenType
    token: Token
    has_emphasis: boolean
}

type TokenType = "TEXT" | "INTEGER_NUMBER" | "PERCENT" | "EMOTE";

type Token = string | number | Emote | User;

interface Emote {
    id: string
}

interface User {
    id: string
    display_name: string
}
```