# Twitchling
Twitchling is a localization library intended to be used by backend services looking to perform localization. It produces a model of fragments that represent text, numbers (with relevant format info), and IDs (to be hydrated by the frontend) with information about the intended display of a given fragment (e.g. emphasis).

# API
TODO: Document the API of Twitchling with examples

# CLI
Twitchling provides a CLI to help with creating projects, validating messages, uploading messages for translation, and downloading translated message bundles.
## Installation
To use the twitchling cli run `go install code.justin.tv/cplat/twitchling/cmd/twitchling`

## Usage
Twitchling provides various sub-commands for managing messages.
### Create a new Twitchling project
To create a new Twitchling project navigate to the directory where your project will live and run `twitchling init`

TODO: Document the project configuration format and setup.
### Validating messages
To validate messages without running the `upload` sub-command you can run the command `twitchling validate` inside the Twitchling project directory.
You may also provide a `--project` (`-p`) flag to the `validate` sub-command to specify a project to be validated.

### Uploading messages
To upload messages to Smartling for translation run `twitchling upload` from the project directory.
You may also provide a `--project` (`-p`) flag to the `upload` sub-command to specify a project to be uploaded.

In order to upload messages the CLI must be able to retrieve your Smartling secret from Sandstorm. You will need to have AWS credentials provided by either
the Isengard console or through the `ada` command for the role you associated with the Sandstorm role.

Messages are validated before upload to ensure they have the correct format so that invalid strings are not uploaded to Smartling.

### Downloaded translated messages
To down translated messages from Smartling run `twitchling download` from the project directory.
You may also provide a `--out` (`-o`) flag to the `download` sub-command to specify a directory to download the translated message bundle to.
Providing the `--project` (`-p`) flag to the `download` sub-command allows you to specify which project settings to use for downloading translations.

In order to download messages the CLI must be able to retrieve your Smartling secret from Sandstorm. You will need to have AWS credentials provided by either
the Isengard console or through the `ada` command for the role you associated with the Sandstorm role.

Messages are validated before upload to ensure they have the correct format so that invalid strings are not uploaded to Smartling.

# Future Plans
Twitchling currently does not support several intended features. Here's a non-exhaustive list of things that remain to be done:

* Support `select` functions
* Numeric variants in plurals (e.g. `=0`, `=1`, etc)
    * Need to validate these work with Smartling!
* Return errors for unsupported features:
    * Multiple selects <-- select is unspported right now, but this will be needed
    * The `selectordinal` feature <-- parser error
    * Offset argument for plurals <-- parser error
    * See the [Smartling ICU MessageFormat](https://help.smartling.com/hc/en-us/articles/360008030994-ICU-MessageFormat) for more information
* Support outputting message validation results in the JUnit test report format (for integration with CI tools)
