package clients

import (
	"errors"

	"code.justin.tv/cplat/twitchling/project"
	"code.justin.tv/systems/sandstorm/manager"
	"github.com/aws/aws-sdk-go/aws/credentials"
)

func GetSandstormSecret(config *project.ProjectConfig) (string, error) {
	credentials := credentials.NewChainCredentials([]credentials.Provider{&credentials.EnvProvider{}, &credentials.SharedCredentialsProvider{}})
	managerConfig := manager.AWSConfig(credentials, config.Sandstorm.RoleARN)
	m := manager.New(manager.Config{AWSConfig: managerConfig})

	secret, err := m.Get(config.Sandstorm.SecretName)
	if err != nil {
		return "", err
	}

	if secret == nil {
		return "", errors.New("secret does not exist")
	}

	return string(secret.Plaintext), nil
}
