package cmd

import (
	"fmt"

	"code.justin.tv/cplat/twitchling/project"
	"github.com/spf13/cobra"
)

var lsCmd = &cobra.Command{
	Use:   "ls",
	Short: "list all strings in a project to assist with requesting localization",
	Long:  ``,
	RunE:  runLS,
}

func init() {
	rootCmd.AddCommand(lsCmd)
}

func runLS(cmd *cobra.Command, args []string) error {
	project, err := project.LoadProject(projectFile)
	if err != nil {
		return fmt.Errorf("ls: failed to load project file %s\n%v", projectFile, err)
	}

	for _, message := range project.Messages {
		for _, variant := range message.Variants {
			cmd.Println(variant)
		}
	}

	return nil
}
