package cmd

import (
	"path/filepath"

	"github.com/fatih/color"
	"github.com/spf13/cobra"
)

var noColor bool
var projectFile string

const (
	projectFlagLong  = "project"
	projectFlagShort = "p"
)

// rootCmd represents the base command when called without any subcommands
var rootCmd = &cobra.Command{
	Use:   "twitchling",
	Short: "Twitchling CLI is used to manage Twitchling projects and bundles",
	Long:  ``,
	PersistentPreRunE: func(cmd *cobra.Command, args []string) (err error) {
		color.NoColor = noColor
		projectFile, err = filepath.Abs(projectFile)

		if err != nil {
			return err
		}

		return nil
	},
	SilenceUsage:  true,
	SilenceErrors: true,
}

func Execute() {
	cobra.CheckErr(rootCmd.Execute())
}

func init() {
	rootCmd.Flags().BoolP("toggle", "t", false, "Help message for toggle")
	rootCmd.PersistentFlags().BoolVarP(&noColor, "no-color", "", false, "disable colorized output")
	rootCmd.PersistentFlags().StringVarP(&projectFile, projectFlagLong, projectFlagShort, "project.toml", "project file to be translated (default is ./project.toml)")
}
