package cmd

import (
	"fmt"

	"code.justin.tv/cplat/twitchling/cmd/twitchling/clients"
	"code.justin.tv/cplat/twitchling/project"
	"github.com/spf13/cobra"
)

var uploadCmd = &cobra.Command{
	Use:   "upload",
	Short: "validate and upload project.toml to Smartling for translation",
	Long:  ``,
	RunE:  runUpload,
}

func init() {
	rootCmd.AddCommand(uploadCmd)
}

func runUpload(cmd *cobra.Command, args []string) error {
	project, err := project.LoadProject(projectFile)
	if err != nil {
		return err
	}

	fmt.Printf("Validating project %s...\n", projectFile)

	if !project.Validate().IsValid() {
		return fmt.Errorf("the project file %s contained invalid messages, run `twitchling validate` for more information", projectFile)
	}

	fmt.Printf("Uploading project %s as %s to Smartling...\n", projectFile, project.Config.Smartling.FileURI)

	secret, err := clients.GetSandstormSecret(&project.Config)
	if err != nil {
		return err
	}

	smartling := clients.NewSmartlingClient(project.Config.Smartling.UserID, secret)
	err = smartling.UploadProject(project)
	if err != nil {
		return err
	}

	fmt.Println("DONE: Upload completed.")

	return nil
}
