package smartling_test

import (
	"testing"

	"code.justin.tv/cplat/twitchling/internal/smartling"
	"code.justin.tv/cplat/twitchling/internal/syntax"
	"github.com/stretchr/testify/assert"
)

func TestValidate(t *testing.T) {
	t.Run("returns no error when no plurals are present", func(t *testing.T) {
		result, err := syntax.Parse("basic test")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.NoError(t, vErr)
	})

	t.Run("returns no error when one plural is present", func(t *testing.T) {
		result, err := syntax.Parse("{test, plural, other {test}}")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.NoError(t, vErr)
	})

	t.Run("returns error when more than one plural is present", func(t *testing.T) {
		result, err := syntax.Parse("{test, plural, other {test}} {test, plural, other {test}}")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.Error(t, vErr)
	})

	t.Run("returns error when more than one plural is present with one nested in an element", func(t *testing.T) {
		result, err := syntax.Parse("{test, plural, other {test}} <em>{test, plural, other {test}}</em>")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.Error(t, vErr)
	})

	t.Run("returns error when more than one plural is present with one nested inside another", func(t *testing.T) {
		result, err := syntax.Parse("{test, plural, other {{test, plural, other {test}}}}")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.Error(t, vErr)
	})

	t.Run("returns error when more than one plural is present with one nested inside an element inside another", func(t *testing.T) {
		result, err := syntax.Parse("{test, plural, other {<em>{test, plural, other {test}}</em>}}")
		assert.NoError(t, err)

		vErr := smartling.Validate(result)
		assert.Error(t, vErr)
	})
}
