package syntax_test

import (
	"testing"

	"code.justin.tv/cplat/twitchling/internal/syntax"
	"github.com/stretchr/testify/assert"
)

func TestNewIndex(t *testing.T) {
	t.Run("should return correct graphemes for the alphabet", func(t *testing.T) {
		input := "abcdefghijklmnopqrstuvwxyz"
		index := syntax.NewIndex(input).Graphemes

		for i := 0; i < len(input); i++ {
			info := index[i]
			assert.Equal(t, i, info.Column())
			assert.Equal(t, input[i:i+1], input[info.Start():info.End()])
		}
	})

	t.Run("should index complex grapheme in multiple positions", func(t *testing.T) {
		//lint:ignore ST1018 reason It's an emoji that I need for testing.
		input := "🏳️‍🌈"
		index := syntax.NewIndex(input).Graphemes

		assert.Len(t, index, 14)
		for _, i := range index {
			assert.Equal(t, 0, i.Column())
			assert.Equal(t, input, input[i.Start():i.End()])
		}
	})

	t.Run("should index line numbers with newline", func(t *testing.T) {
		input := "a\nb"
		index := syntax.NewIndex(input).Graphemes

		assert.Len(t, index, 3)
		assert.Equal(t, 0, index[0].Column())
		assert.Equal(t, 0, index[0].Line())

		assert.Equal(t, 1, index[1].Column())
		assert.Equal(t, 0, index[1].Line())

		assert.Equal(t, 0, index[2].Column())
		assert.Equal(t, 1, index[2].Line())
	})

	t.Run("should index lines correctly", func(t *testing.T) {
		input := "test\ninput\nacross\r\nlines"
		index := syntax.NewIndex(input).Lines

		assert.Len(t, index, 4)
	})
}
