package syntax

import "fmt"

const (
	helpMessage_AddClosingCurlyBrace    = "add `}` here"
	helpMessage_RemoveClosingCurlyBrace = "remove `}` here"
)

type ParseError struct {
	message     string
	help        string
	startLine   int      // 0-indexed line, add 1 for display
	startColumn int      // 0-indexed column, add 1 for display
	endLine     int      // 0-indexed line, add 1 for display
	endColumn   int      // 0-indexed column, add 1 for display
	context     []string // each line involved in the error
}

func (e *ParseError) Message() string {
	return e.message
}

func (e *ParseError) Help() string {
	return e.help
}

func (e *ParseError) StartLine() int {
	return e.startLine
}

func (e *ParseError) StartColumn() int {
	return e.startColumn
}

func (e *ParseError) EndLine() int {
	return e.endLine
}

func (e *ParseError) EndColumn() int {
	return e.endColumn
}

func (e *ParseError) Context() []string {
	return e.context
}

func (e *ParseError) Error() string {
	return fmt.Sprintf("Line %d, Column %d: %s", e.startLine, e.startColumn, e.message)
}
