// +build gofuzzbeta

package syntax_test

import (
	"testing"

	"code.justin.tv/cplat/twitchling/internal/syntax"
)

func FuzzParser(f *testing.F) {
	f.Add("{arg, plural, one {# viewer} other {# <em>viewers</em>}}")

	f.Fuzz(func(t *testing.T, input string) {
		result, err := syntax.Parse(input)
		if err != nil {
			t.Skip()
		}

		if len(result.Root()) == 0 {
			t.Fatalf("valid input %s produced empty AST", input)
		}
	})
}
