package syntax

type tokenKind byte

const (
	tokenKind_EOI tokenKind = iota
	tokenKind_WS
	tokenKind_OpenBrace            // {
	tokenKind_CloseBrace           // }
	tokenKind_Hash                 // #
	tokenKind_Colon                // :
	tokenKind_Comma                // ,
	tokenKind_Equal                // =
	tokenKind_Text                 // raw span of text without white space
	tokenKind_Number               // raw span of digits
	tokenKind_Plural               // keyword 'plural'
	tokenKind_Select               // keyword 'select'
	tokenKind_Offset               // keyword 'offset'
	tokenKind_Zero                 // keyword 'zero'
	tokenKind_One                  //keyword 'one'
	tokenKind_Two                  //keyword 'two'
	tokenKind_Few                  //keyword 'few'
	tokenKind_Many                 // keyword 'many'
	tokenKind_Other                // keyword 'other'
	tokenKind_FormatNumber         // keyword 'number'
	tokenKind_FormatTime           // keyword 'time'
	tokenKind_FormateDate          // keyword 'date'
	tokenKind_NumberFormatInteger  // keyword 'integer'
	tokenKind_NumberFormatCurrency // keyword 'currency'
	tokenKind_NumberFormatPercent  // keyword 'percent'
	tokenKind_ElementOpenStart     // <
	tokenKind_ElementCloseStart    // </
	tokenKind_ElementEnd           // >
	tokenKind_ElementName          // raw span of alpha characters and :

	// Errpr token
	tokenKind_Error
)

type Token struct {
	kind    tokenKind
	start   int
	end     int
	message string
}

func (t Token) Kind() tokenKind {
	return t.kind
}

func (t Token) Start() int {
	return t.start
}

func (t Token) End() int {
	return t.end
}

func (t Token) Message() string {
	return t.message
}

var known_keywords map[string]tokenKind = map[string]tokenKind{
	"plural":   tokenKind_Plural,
	"select":   tokenKind_Select,
	"offset":   tokenKind_Offset,
	"zero":     tokenKind_Zero,
	"one":      tokenKind_One,
	"two":      tokenKind_Two,
	"few":      tokenKind_Few,
	"many":     tokenKind_Many,
	"other":    tokenKind_Other,
	"number":   tokenKind_FormatNumber,
	"time":     tokenKind_FormatTime,
	"date":     tokenKind_FormateDate,
	"integer":  tokenKind_NumberFormatInteger,
	"currency": tokenKind_NumberFormatCurrency,
	"percent":  tokenKind_NumberFormatPercent,
}
