package message

import (
	"fmt"
)

type PlaceholderErrorKind byte

const (
	PlaceHolderError_NotFound PlaceholderErrorKind = iota
	PlaceHolderError_NumberExpected
)

type PlaceholderError struct {
	kind     PlaceholderErrorKind
	argument string
}

func newPlaceholderError(kind PlaceholderErrorKind, argument string) *PlaceholderError {
	return &PlaceholderError{kind, argument}
}

func (p *PlaceholderError) Error() string {
	switch p.kind {
	case PlaceHolderError_NotFound:
		return fmt.Sprintf("placeholder %s not found", p.argument)

	case PlaceHolderError_NumberExpected:
		return fmt.Sprintf("placeholder %s is expected to be a number", p.argument)

	default:
		panic("unreachable")
	}
}
