package message

import (
	"code.justin.tv/cplat/twitchling/internal/syntax/ast"
	"code.justin.tv/cplat/twitchling/localization/language"
)

type messageFormatter struct {
	language     language.Tag
	fragments    []Fragment
	placeholders PlaceholderMap
}

func newMessageFormatter(language language.Tag, placeholders PlaceholderMap) *messageFormatter {
	return &messageFormatter{
		language:     language,
		fragments:    nil,
		placeholders: placeholders,
	}
}

func (m *messageFormatter) format(nodes []ast.Node) ([]Fragment, error) {
	for _, node := range nodes {
		err := m.visitNode(visitorContext{}, node)
		if err != nil {
			return nil, err
		}
	}

	return m.fragments, nil
}
