package project

import (
	"errors"

	"code.justin.tv/cplat/twitchling/localization/message"
)

const (
	Default = "default"
)

type MessageSet struct {
	Messages []Message `json:"messages" toml:"messages"`
}

func (p *MessageSet) Validate() ValidationResult {
	var messages []ValidatedMessage

	for _, m := range p.Messages {
		if _, ok := m.Variants[Default]; !ok {
			messages = append(messages, ValidatedMessage{m.ID, Default, errors.New("missing required variant default")})
		}

		for variantID, v := range m.Variants {
			err := message.Validate(v)
			if err != nil {
				messages = append(messages, ValidatedMessage{m.ID, variantID, err})
				continue
			}

			messages = append(messages, ValidatedMessage{m.ID, variantID, nil})
		}
	}

	return ValidationResult{messages}
}

type ValidatedMessage struct {
	ID      string
	Variant string
	Error   error
}

type ValidationResult struct {
	Results []ValidatedMessage
}

func (r ValidationResult) IsValid() bool {
	for _, m := range r.Results {
		if m.Error != nil {
			return false
		}
	}

	return true
}
