package project_test

import (
	"testing"

	"code.justin.tv/cplat/twitchling/project"
	"github.com/stretchr/testify/assert"
)

func TestPlaceholders(t *testing.T) {
	t.Run("retrieves all placeholders from all variants", func(t *testing.T) {
		message := project.Message{
			Variants: map[string]string{
				"default": "{arg1}",
				"other":   "{arg2}",
			},
		}

		placeholders, err := message.Placeholders()

		assert.Len(t, placeholders, 2)
		assert.NoError(t, err)
		assert.Contains(t, placeholders, "arg1")
		assert.Contains(t, placeholders, "arg2")
	})

	t.Run("retrieves all placeholders from all variants with no duplicates", func(t *testing.T) {
		message := project.Message{
			Variants: map[string]string{
				"default": "{arg2} {arg1} {arg3}",
				"other":   "{arg1} {arg2}",
			},
		}

		placeholders, err := message.Placeholders()

		assert.Len(t, placeholders, 3)
		assert.NoError(t, err)
		assert.Contains(t, placeholders, "arg1")
		assert.Contains(t, placeholders, "arg2")
		assert.Contains(t, placeholders, "arg3")
	})

	t.Run("retrieves all placeholders from number functions from all variants", func(t *testing.T) {
		message := project.Message{
			Variants: map[string]string{
				"default": "{arg1, number, percent}",
				"other":   "{arg2, number, percent}",
			},
		}

		placeholders, err := message.Placeholders()

		assert.Len(t, placeholders, 2)
		assert.NoError(t, err)
		assert.Contains(t, placeholders, "arg1")
		assert.Contains(t, placeholders, "arg2")
	})

	t.Run("retrieves all placeholders from all variants with elements", func(t *testing.T) {
		message := project.Message{
			Variants: map[string]string{
				"default": "<em>{arg1}</em>",
				"other":   "<em>{arg2}</em>",
			},
		}

		placeholders, err := message.Placeholders()

		assert.Len(t, placeholders, 2)
		assert.NoError(t, err)
		assert.Contains(t, placeholders, "arg1")
		assert.Contains(t, placeholders, "arg2")
	})

	t.Run("retrieves all placeholders from all variants with elements in plurals", func(t *testing.T) {
		message := project.Message{
			Variants: map[string]string{
				"default": "{x, plural, other {<em>{arg1}</em>}}",
				"other":   "{x, plural, one {<em>{arg2}</em>} other {<em>{arg1}</em>}}",
			},
		}

		placeholders, err := message.Placeholders()

		assert.Len(t, placeholders, 3)
		assert.NoError(t, err)
		assert.Contains(t, placeholders, "x")
		assert.Contains(t, placeholders, "arg1")
		assert.Contains(t, placeholders, "arg2")
	})
}
