package project

import (
	"io/ioutil"

	"github.com/pelletier/go-toml"
)

type SmartlingSettings struct {
	UserID    string `toml:"user-id"`
	ProjectID string `toml:"project-id"`
	FileURI   string `toml:"file-uri"`
}

type SandstormSettings struct {
	RoleARN    string `toml:"role-arn"`
	SecretName string `toml:"secret-name"`
}

type ProjectConfig struct {
	Smartling SmartlingSettings `toml:"smartling"`
	Sandstorm SandstormSettings `toml:"sandstorm"`
}

type Project struct {
	MessageSet
	Config ProjectConfig `toml:"config"`
}

func LoadProject(path string) (*Project, error) {
	data, err := ioutil.ReadFile(path)
	if err != nil {
		return nil, err
	}

	var project Project
	err = toml.Unmarshal(data, &project)
	if err != nil {
		return nil, err
	}

	return &project, nil
}
