import Component from '@ember/component';
import { computed } from '@ember/object';

export default Component.extend({

  classNames: ['business-card-container'],
  // attributeBindings: ['style'],

  // style: "height: 400px;",

  qs: computed('{name,email,title,phone,twitch,twitter,skype}', function () {
    let query = [];

    ['name', 'email', 'title', 'phone', 'twitch', 'twitter', 'skype'].forEach((key) => {
      let value = this.get(key) || '';
      query.push(`${key}=${encodeURIComponent(value)}`)
    });

    return query.join('&');
  }),

  // https://www.adobe.com/content/dam/acom/en/devnet/acrobat/pdfs/pdf_open_parameters.pdf
  cardUrl: computed('qs', function () {
    return `http://localhost.twitch.tv:3000/card?${this.qs}#toolbar=0&navpanes=0&scrollbar=0&view=Fit`;
  })

});
