# Twitch.tv Business Card Workflow

## Step 1: Wufoo

Users submit a business card request via: [link.twitch.tv/businesscards](http://link.twitch.tv/businesscards)

To import these records and generate a pdf proof you will run:

```
node index generate
```

This will download the latest data from wufoo and generate the business cards in the `00 Pending` folder.

## Step 2: Send Proof Emails

Once a creative services member reviews the business card proofs they will approve them by moving the approved pdf's into the `01 Email Proofs` folder.

**NOTE:** The file in this folder is expected to be named `{quantity}-{email}.pdf`.

To send the user a proof email you will run:

```
node index proof
```

This will send an email and move the associated pdf into the `02 Pending Approval` folder.

### Manual Business Cards

You can also manually create a business card PDF and drop it in the `01 Email Proofs` folder with the name of `{quantity}-{email}.pdf`. This file will also be picked up by the `node index proof` command.

## Step 3: Approvals

When creative services gets an email back from the user with an approval, the cretive services memebr will move the approved PDF's into the `03 Approved` folder.

### Reminders

Occasionally users will forget to reply with an "approval". To send them a reminder email you can run:

```
node index reminder
```

This will look at all of the PDF's in the `02 Pending Approval` folder and send the user another reminder email.

## Step 4: Finalizing For Print

Once all of the business cards have been approved and moved into the `03 Approved` folder you can run:

```
node index finalize
```

This will move all of the PDF files from `03 Approved` into the `04 Finals` folder. This will also place the PDF into a subfolder indicating the quantity to be ordered.


# Configuration

All configuration is managed through a `.env` file in the project root.

```
# Fullpath to your dropbox folder that holds the workflow folders above
WORKFLOW_PATH=

# Wufoo form detaisl to pull data from
WUFOO_KEY=
WUFOO_SUBDOMAIN=creativeservicestwitch
WUFOO_FORM=business-card-request-form

# Mailgun details for sending proof and reminder emails
MAILGUN_API_KEY=
MAILGUN_DOMAIN=creativeservices.twitch.tv
```

# Version 2.0

There is an express server that will generate the PDF.

```
$ node server
```

There is also an ember client that gives the user a way to preview their card.

```
$ cd app && ember s
```