const express = require('express');
const bodyParser = require('body-parser');
const app = express();
const port = process.env['PORT'] || 3000;
const Path = require('path');
const tmpl = require('./template');

app.use(bodyParser.json());

app.use((err, req, res, next) => {
  console.error(err.stack)
  res.status(500).send('Something broke!')
});

app.get('/card', (req, res) => {
  let entry = req.query || {};

  res.setHeader('content-type', 'application/pdf');
  res.setHeader('x-recipient', entry.email);
 
  tmpl.build('business-card-request-form', res, entry);
});

app.listen(port, () => {
  console.info(`listening on port ${port}`);
});
