const chalk = require('chalk');
const PDFDocument = require('pdfkit');
// let purple = [69, 75, 0, 0];
let purple = [61, 74, 0, 0];
// let purple = '#7f56c5';
let grey = [71, 65, 64, 69];
// let grey = '#262626';

// 4.5x3
// 5.5x4

const points = function (inches, dpi = 72) {
  return inches * dpi;
};

const swapFont = function (doc, value) {
  let matches = value.match(/[^\x00-\x7F]+/g);
  let lines = [];
  let position = 0;

  if (!matches) {
    return [{ font: 'primary', line: [value, 49.5, 57.5] }];
  }

  matches.forEach((match, matchNumber) => {
    let index = value.indexOf(match, position);
    let length = match.length;
    let continued = matchNumber !== matches.length - 1;

    lines.push({ font: 'primary', size: 25.1, line: [value.slice(position, index), 49.5, 57.5, { continued: true }] });
    lines.push({ font: 'primary-special', size: 16, line: [value.slice(index, index + length), { continued }] });

    position = index + length;
  });

  // console.log(lines);

  return lines;
};

const addCropMarks = function (document, [width, height], bleed) {
  let gap = points(0.125);
  let marks = [
    // top left
    [0, bleed, bleed - gap, bleed],
    [bleed, 0, bleed, bleed - gap],
    // bottom left
    [0, height - bleed, bleed - gap, height - bleed],
    [bleed, height, bleed, height - bleed + gap],
    // top right
    [width, bleed, width - bleed + gap, bleed],
    [width - bleed, 0, width - bleed, bleed - gap],
    // bottom right
    [width, height - bleed, width - bleed + gap, height - bleed],
    [width - bleed, height, width - bleed, height - bleed + gap],
  ];

  marks.forEach(([x1, y1, x2, y2]) => {
    document.lineWidth(0.5)
            .moveTo(x1, y1)
            .lineTo(x2, y2)
            .stroke();
  });
};

const text = function (document, family, size, color, options) {
  let set = function () {
    return document.fontSize(size)
                   .font(family)
                   .fillColor(color);
  };

  return {
    width(value) {
      return set().widthOfString(value, options);
    },
    height (value) {
      return set().heightOfString(value, options);
    },
    write() {
      let args = Array.prototype.slice.apply(arguments);
      args.push(options);
      return set().text.apply(document, args);
    }
  }
};

const contact = function (document, space) {
  let labelText = text(document, 'secondary', 4.25, purple, { characterSpacing: 0.5 });
  let valueText = text(document, 'secondary', 5.4, grey, { characterSpacing: 0.35 });

  return {
    width: function (label, value) {
      let labelWidth = labelText.width(label);
      let valueWidth = valueText.width(value);
      if (value) {
        return space + Math.max(labelWidth, valueWidth);
      }
      return 0;
    },
    write: function (label, value, left) {
      if (value) {
        labelText.write(label, left, 155);
        valueText.write(value, left, 162);
      }
    }
  };
};

const contacts = function (document, space) {
  let contactText = contact(document, space);

  return {
    width: function (records) {
      return records.reduce((width, [ label, value ]) => {
        return width + contactText.width(label, value);
      }, 0);
    },
    write: function (records, left) {
      records.reduce((l, [ label, value ]) => {
        contactText.write(label, value, l);
        return l + contactText.width(label, value);
      }, left);
    }
  };
};

const mergeSocial = function (social) {
  let socialIndex = social.reduce((index, value) => {
    let [ , username] = value;
    let key = username.toLowerCase();
    if (key) {
      index[key] = index[key] || [];
      index[key].push(value);
    }
    return index;
  }, {});

  return Object.keys(socialIndex).map((key) => {
    let socials = socialIndex[key];
    return socials.reduce(([label, value], [socialLabel, socialValue]) => {
      let key = [label, socialLabel].join(' / ');
      return [key, value || socialValue];
    });
  });
};

const generate = function (output, data) {
  let size = [points(4.5), points(3)] // 4.5 × 3 * 72
  let margin = points(0.5);
  let left = points(0.7);
  let glitch = points(0.56);
  let errored = false;
  // let glitch = points(0);

  let { name, email, title, phone, twitch, twitter, skype, quantity: note } = data;
  let doc = new PDFDocument({ size, margin });
  let [ width, ] = size;
  let maxWidth = width - left - glitch;

  doc.registerFont('primary', 'fonts/korolev-bold.otf');
  doc.registerFont('secondary', 'fonts/univers-next-pro-regular.ttf');

  doc.pipe(output);

  let nameText = text(doc, 'primary', 25.1, grey, { characterSpacing: -0.3 });
  let titleText = text(doc, 'secondary', 5.6, purple, { characterSpacing: 0.35 });
  let emailText = text(doc, 'secondary', 9.5, grey, { characterSpacing: 0.15 });
  let contactGroup = contacts(doc, points(0.125));

  let social = [
    ['TWITCH ID', twitch],
    ['TWITTER', twitter],
    ['SKYPE', skype],
  ];

  let contactData = [
  ];
  
  if (phone) {
    contactData.push(['MOBILE', phone]);
  }

  contactData = contactData.concat(mergeSocial(social));
  contactData.push(['SECRET HEADQUARTERS', 'www.twitch.tv']);

  if (maxWidth < contactGroup.width(contactData)) {
    contactData.pop();
    contactData.push(['SECRET LAIR', 'www.twitch.tv']);
  }

  if (maxWidth < contactGroup.width(contactData)) {
    console.error('too many contacts', maxWidth, contactGroup.width(contactData));
    // clear out contact data so the card get created
    contactData = contactData.map(([label, value]) => [label, "FIXME"]);
    errored = true;
  }

  // if (maxWidth < nameText.width(name)) {
    // name = 'Too Long';
    // throw new Error('name too long');
    // console.log(nameText.height(name));
  // }

  // addCropMarks(doc, size, margin);

  // swapFont(doc, name);
  nameText.write(name, left, 57.5);
  titleText.write(title, left, 62 + nameText.height(name));
  emailText.write(email, left, 138.5);
  contactGroup.write(contactData, left);

  doc.end();

  // if (errored) {
  //   throw new Error('too many contacts');
  // }
}
module.exports = generate;