const Path = require('path');
const fs = require('fs');
const chalk = require('chalk');

const { mkdirp } = require('../utils');

exports.build = (templateName, outputStream, data) => {
  let template = require(`./${templateName}`);
  return template(outputStream, data)
};

exports.generate = function (templateName, entry, filename) {
  let path = Path.dirname(filename);

  return mkdirp(path)
          .then(() => fs.createWriteStream(filename))
          .then((stream) => exports.build(templateName, stream, entry))
          .catch((error) => {
            let data = JSON.stringify(entry, null, 2);

            let folder = Path.dirname(filename)
            let name = Path.basename(filename);
            let source = Path.join(folder, name);
            let destination = Path.join(folder, `_${name}`);
            let errorFile = Path.join(folder, `_${entry.email}.txt`);

            console.log(chalk.red(data), error);

            fs.renameSync(source, destination);

            // fs.unlinkSync(filename);
            return fs.writeFileSync(errorFile, data);
          });
};