const fs = require('fs');
const RSVP = require('rsvp');
const nodemailer = require('nodemailer');
const Handlebars = require('handlebars');

const send = function (from, subject, template, reallySend = true) {
  try {
    let html = fs.readFileSync(template, 'utf-8');
    let hbs = Handlebars.compile(html);
    let mailgun = require('nodemailer-mailgun-transport');

    let transportConfig = mailgun({
      auth: {
        api_key: process.env['MAILGUN_API_KEY'],
        domain: process.env['MAILGUN_DOMAIN']
      }
    });

    let transporter = nodemailer.createTransport(transportConfig);

    return function (email, file, data = {}) {
      let html = hbs(data);

      let message = {
        from,
        to: email,
        subject,
        html,
        attachments: [{
          path: file
        }]
      };

      if (!reallySend) {
        console.log('fake sending', subject, message);
        return RSVP.Promise.resolve();
      }

      console.log('sending', subject, message);
      return new RSVP.Promise((resolve, reject) => {
        // send mail with defined transport object
        transporter.sendMail(message, (error, info) => {
          if (error) return reject(error);
          resolve(info);
        });
      });
    };
  }
  catch(error) {
    return () => {
      throw error;
    };
  }
};

module.exports = send;

