module.exports = function (base) {
  const Path = require('path');
  const { move, chain, loadFolder } = require('../../utils');

  const folder = "03 Approved";
  const cwd = Path.join(base, folder);

  const data = require('../../data');
  const store = data('entries.json');

  const process = function (proof) {
    if (!proof) return;
    let { record } = proof;

    return promote(proof).then(() => store.finalized(record));
  };

  const promote = function (proof) {
    let folder = "04 Finals";
    let { file, record } = proof;
    let filename = Path.basename(file);
    let destination = Path.join(base, folder, record.quantity.toString(), filename);
    return move(file, destination);
  };

  return loadFolder(store, cwd).then((approved) => {
      return chain(approved, process).then(() => approved);
    })
    .then((entries) => {
      console.log('FINALIZED', entries.length, 'proofs');
    })
    .catch((error) => {
      console.error(error);
    });
};