module.exports = function (base) {
  const Path = require('path');
  const data = require('../../data');
  const tmpl = require('../../template');
  const { chain } = require('../../utils');

  const store = data('entries.json');

  const generate = function (entry) {
    let folder = '00 Pending';
    let name = `${entry.quantity}-${entry.email}.pdf`;
    let filename = Path.join(base, folder, name);

    return tmpl.generate('business-card-request-form', entry, filename)
                   .then(() => store.inReview(entry));
  };

  return store.pending().then((entries) => {
      return chain(entries, generate)
        .then(() => {
          console.log('GENERATED', entries.length, 'proofs');
        });
    })
    .catch((error) => {
      console.error('entries', error);
    });
};
