module.exports = function (base) {
  const Path = require('path');
  const { move, chain, sendProof, loadFolder } = require('../../utils');

  const folder = "01 Email Proofs";
  const cwd = Path.join(base, folder);

  const data = require('../../data');
  const store = data('entries.json');

  const process = function (proof) {
    if (!proof) return;
    let { file, record } = proof;

    return sendProof(record.email, file, record)
            .then(() => promote(file))
            .then(() => store.proofSent(record));
  };

  const promote = function (file) {
    let folder = "02 Pending Approval";
    let filename = Path.basename(file);
    let destination = Path.join(base, folder, filename);
    return move(file, destination);
  };

  return loadFolder(store, cwd).then((proofs) => {
      return chain(proofs, process).then(() => proofs);
    })
    .then((entries) => {
      console.log('SENT', entries.length, 'proofs');
    })
    .catch((error) => {
      console.error(error);
    });
};