module.exports = function (base) {
  const Path = require('path');
  const { chain, sendReminder, loadFolder } = require('../../utils');
  const data = require('../../data');

  const store = data('entries.json');

  const folder = "02 Pending Approval";
  const cwd = Path.join(base, folder);

  const process = function (proof) {
    if (!proof) return;
    let { file, record } = proof;

    return sendReminder(record.email, file, record)
            .then(() => store.reminderSent(record));
  };

  return loadFolder(store, cwd).then((proofs) => {
      return chain(proofs, process).then(() => proofs);
    })
    .then((entries) => {
      console.log('SENT', entries.length, 'reminders');
    })
    .catch((error) => {
      console.error(error);
    });
};