# Creator Camp QA Chat Bot

The CreatorCamp chatbot sits in the creatorcamp channel and listend for messages that start with `!ask`. Every `!ask`ed question is then dumped into a [google sheet](https://docs.google.com/spreadsheets/d/1sqOcidx1nb7FXzXLsYm8yN9nqQ4B6XsBqorI3yaWOVU) for the current creator and staff to moderate and prioritize.

The chatbot will also periodically make an announcement reminding the viewers to `!ask` a question.


## Configuration

An [OAuth token must be generated](https://twitchapps.com/tmi/) for the bot to work. This must be done from the `creatorcamp` account.

```
// config.json

{
  "bot": {
    "announce": "Type !ask followed by your question about networking with other streamers",
    "announcement_minute_interval": 4
  },
  "twitch: {
    "options": {
      "debug": false
    },
    "connection": {
      "reconnect": true
    },
    "identity": {
      "username": "creatorcamp",
      "password": "oauth:"
    },
    "channels": [
      "#creatorcamp"
    ]
  },
  "google": {
    "id": "1sqOcidx1nb7FXzXLsYm8yN9nqQ4B6XsBqorI3yaWOVU",
    "credentials": {
      "type": "",
      "project_id": "",
      "private_key_id": "",
      "private_key": "",
      "client_email": "",
      "client_id": "",
      "auth_uri": "",
      "token_uri": "",
      "auth_provider_x509_cert_url": "",
      "client_x509_cert_url": "  
    }
  }
}
```

## Running The Chatbot

```
$ npm start
```

1. Update the `config.json#bot.announce` to reflect the current creator camp topic.
2. Before the live creator camp session, run the bot to ensure the OAuth (`config.json#twitch.identity.password`) is still valid. If it is not, you will need to have [@brittany](slack://user?team=T0266V6GF&id=U063VEJ87) regenerate it for you.
3. Type `!ask is this thing on?` into chat and verify the question has been added into the [google doc](https://docs.google.com/spreadsheets/d/1sqOcidx1nb7FXzXLsYm8yN9nqQ4B6XsBqorI3yaWOVU).


The bot must stay running the entirety to the live stream. 