const _ = require('lodash');
const _request = require('request');
const RSVP = require('rsvp');
const endpoint = 'http://lcs.internal.twitch.tv/api/twirp/code.justin.tv.growth.userlifecycle.Userlifecycle';
const request = RSVP.denodeify(_request, ['res', 'body']);

const listTemplates = (limit = 1) => {
  const url = `${endpoint}/ListTemplates`;
  const method = 'POST';
  const json = { limit };

  return request({ url, method, json }).then(({ body }) => body.templates);
};

const findTemplate = (name) => {
  return listTemplates(100)
    .then((templates) => _.find(templates, { name }))
    .then((template) => {
      if (!template) throw 'not found';
      return template;
    });
};

const updateTemplate = (id, body, plainBody) => {
  const url = `${endpoint}/UpdateTemplate`;
  const method = 'POST';
  const json = { id, body, plainBody };

  return request({ url, method, json }).then(({ body }) => body);
};

const createTemplate = (name, body, plainBody) => {
  const url = `${endpoint}/CreateTemplate`;
  const method = 'POST';
  const json = { name, body, plainBody };

  return request({ url, method, json }).then(({ body }) => body);
};

const createOrUpdate = (name, body, plainBody) => {
  return findTemplate(name).then((template) => {
    let { id, body: _body, plain_body: _plainBody } = template;
    let changed = body !== _body || plainBody !== _plainBody;

    if (!changed) return template;

    return updateTemplate(id, body, plainBody);
  })
  .catch((error) => {
    if ('not found' === error) {
      return createTemplate(name, body, plainBody);
    }

    throw error;
  });
};

module.exports = { listTemplates, updateTemplate, findTemplate, createTemplate, createOrUpdate };