# array-last [![NPM version](https://img.shields.io/npm/v/array-last.svg)](https://www.npmjs.com/package/array-last) [![Build Status](https://img.shields.io/travis/jonschlinkert/array-last.svg)](https://travis-ci.org/jonschlinkert/array-last)

> Get the last or last n elements in an array.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install array-last --save
```

## Usage

```js
var last = require('array-last');

last(['a', 'b', 'c', 'd', 'e', 'f']);
//=> 'f'

last(['a', 'b', 'c', 'd', 'e', 'f'], 1);
//=> 'f'

last(['a', 'b', 'c', 'd', 'e', 'f'], 3);
//=> ['d', 'e', 'f']
```

## Related projects

* [arr-union](https://www.npmjs.com/package/arr-union): Combines a list of arrays, returning a single array with unique values, using strict equality… [more](https://www.npmjs.com/package/arr-union) | [homepage](https://github.com/jonschlinkert/arr-union)
* [array-unique](https://www.npmjs.com/package/array-unique): Return an array free of duplicate values. Fastest ES5 implementation. | [homepage](https://github.com/jonschlinkert/array-unique)
* [array-xor](https://www.npmjs.com/package/array-xor): Returns the symmetric difference (exclusive-or) of an array of elements (elements that are present in… [more](https://www.npmjs.com/package/array-xor) | [homepage](https://github.com/jonschlinkert/array-xor)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/array-last/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016 [Jon Schlinkert](https://github.com/jonschlinkert)
Released under the [MIT license](https://github.com/jonschlinkert/array-last/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on March 09, 2016._