# @title AWS SDK for JavaScript

# AWS SDK for JavaScript

<p class="subtitle">Available for browsers and mobile devices, or Node.js backends</p>

## Developer Guide

<p class="note">
If you are upgrading from 1.x to 2.0 of the SDK, please see
the {file:UPGRADING.md} notes for information on how to migrate existing code
to work with the new major version.
</p>

The **AWS SDK for JavaScript** allows developers to build libraries or
applications that make use of AWS services using a simple and easy-to-use
API available both in the browser or inside of Node.js applications on the
server.

This guide will walk developers through many of the high level concepts
that the SDK provides, as well as provide example code to get started with
some services. For a more complete look at the classes and methods provided by
the library, it is recommended to look at the SDK's
[API reference documentation](http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/frames.html).

Depending on the platform you are developing for, the installation guide
may be slightly different, but in both cases, usage of the SDK is the same.

## Select a Platform

<div class="buttons">
{file:browser-intro.md JavaScript in the Browser}
{file:node-intro.md JavaScript in Node.js}
</div>
<div class="clear"></div>

If you are developing applications in the browser, please visit the
{file:browser-intro.md AWS SDK for JavaScript in the Browser} section.

If you are developing applications on the server side using Node.js, see the
{file:node-intro.md AWS SDK for Node.js} section.
