const ApiBuilder = require('claudia-api-builder');
const fetch = require('node-fetch');
const api = new ApiBuilder();
const clientId = '54v34lfkzdsgzhc40yzweqlwev0tyk'; // marketing client id
const entitlementsHost = 'http://tesla-dev-commerce-tesla-env.9apa4ngbzg.us-west-2.elasticbeanstalk.com';

const getEntitlements = async (userId) => {
  const endpoint = `${entitlementsHost}/commerce/user/goods`;
  let response = await fetch(`${endpoint}?tuid=${userId}`, {
    method: 'post',
    headers: {
      'client-id': clientId
    }
  });

  return response.json();
};

const getCurrentUser = async (token) => {
  let response = await fetch('https://api.twitch.tv/kraken/user', {
    headers: {
      'client-id': clientId
      'authorization': `OAuth ${token}`
    }
  });

  return response.json();
};

api.get('/api/v1/entitlements/pubg', async ({ headers }) => {
  let [, token] = /^oauth (.*?)$/i.exec(headers.Authorization) || [];
  let { _id } = await getCurrentUser(token);

  if (_id) {
    return getEntitlements(_id);
  }

  throw new Error('not authorized');
}, {
  error: { code: 403 }
});

module.exports = api;


