import DS from 'ember-data';
// import { run } from '@ember/runloop';
import { Promise, resolve, reject } from 'rsvp';

export default DS.RESTAdapter.extend({

  createRecord(store, type, snapshot) {
    let data = this.serialize(snapshot, { includeId: true });

    return resolve({ [type.modelName]: data });
  },

  updateRecord(store, type, snapshot) {
    let message = this.serialize(snapshot, { includeId: true });
    let { socket, channel } = snapshot.record;

    if (socket) {
      return new Promise(() => {
        socket.publish({ channel, message }, (status) => {
          if (status.error) return reject(status);
          resolve({ [type.modelName]: message });
        });
      });
    }

    return reject('missing socket');
  }
});
