import ApplicationAdapter from './application';
import fetch from 'fetch';

export default ApplicationAdapter.extend({

  query(store, type, variables) {
    return fetch('https://api.twitch.tv/gql', {
      method: 'post',
      headers: {
        'client-id': '54v34lfkzdsgzhc40yzweqlwev0tyk'
        // 'client-id': 'kimne78kx3ncx6brgo4mv6wki5h1ko'
      },
      body: JSON.stringify({
        variables,
        query: `query ($logins: [String!]) {
          users(logins: $logins) {
            id
            displayName
            login
            profileImageURL(width: 600)
            stream {
              type
            }
          }
        }`
      })
    })
    .then((response) => response.json())
    .then(({ data }) => data)
    .then(({ users }) => users || [])
    .then((data) => data.filter(({ id }) => id))
    .then((data) => {
      return { [type.modelName]: data };
    });
    // .catch((error) => console.log(error));
  }

});
